<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
  <title>Blog</title>
  <link rel="stylesheet" href="/mbtech/layui.css">
  <link rel="stylesheet" href="/mbtech/common.css">
  <style>
    .blog_body {
      background-image: url("/mbtech/mb/bg12.png");
      background-size: 100%;
      background-repeat: no-repeat;
    }
    .index_header {}

    .blog_contents {
      position: relative;
      background: none;
      margin: 15px;
      margin-bottom: 200px;
    }
    .bold_card {
      background: #FFFFFF;
      padding: 15px;
      margin-bottom: 15px;
      border-radius: 16px;
      box-shadow: 0px 4px 10px 0px rgba(0,56,99,0.2);
    }
    .bold_card .card_header {
      display: flex;
      justify-content: space-between;
    }
    .bold_card .card_header .title {
      display: flex;
      justify-content: left;
    }
    .bold_card .card_header .title .info {
      padding-left: 10px;
    }
    .bold_card .card_header .title .nickname {
      font-weight: 700;
      font-size: 16px;
      color: #333333;
      line-height: 18px;
    }
    .bold_card .card_header .title .account {
      font-weight: 400;
      font-size: 14px;
      color: #888888;
      line-height: 16px;
    }
    .avatar {
      width: 40px;
      height: 40px;
      border-radius: 50%;
      border: 1px solid #EEEEEE;
    }
    .blog_img {
      width: 100%;
      min-height: 84px;
    }
    .footer {
      margin-left: 40px;
      display: flex;
      justify-content: space-between;
    }
    .footer img {
      width: 16px;
      height: 16px;
    }
    .date {
      font-size: 14px;
      color: #A6A6A8;
    }
    .icon {
      font-size: 16px;
      color: #FCAA00;
    }

    /* Dialog Style */
    .dialog {
      display: none;
      position: fixed;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      background: rgba(0,0,0,0.5);
      justify-content: center;
      align-items: center;
      z-index: 9999;
    }
    .dialog_contents {
      background: white;
      padding: 20px;
      border-radius: 12px;
      width: 90%;
      max-width: 400px;
      text-align: center;
      font-family: Arial;
    }
    .dialog .explain {
      font-weight: bold;
      font-size: 18px;
      margin-bottom: 10px;
    }
    .dialog .title {
      font-size: 16px;
      margin: 10px 0;
    }
    .dialog .text {
      font-size: 14px;
      color: #666;
    }
    .dialog button {
      margin-top: 20px;
      background: linear-gradient(270deg, #0672B5 0%, #1C8ED5 100%);
      color: white;
      border: none;
      padding: 10px;
      border-radius: 100px;
      width: 100%;
      font-size: 16px;
    }
  </style>
</head>
<body class="blog_body">
  <div style="font-weight: 700;font-size: 18px;color: #FFFFFF;text-align: center;margin-top: 40px">Blog</div>
  <div style="font-weight: 700;font-size: 18px;color: #FFFFFF;line-height: 28px;padding-left: 20px;margin-top: 50px;">Upload your withdrawal voucher</div>
  <div style="font-weight: 500;font-size: 14px;color: #ECF7FF;line-height: 22px;padding-left: 20px">Share the joy with everyone</div>

  <div class="blog_contents" id="blog_contents" style="overflow: hidden; position: relative; top: -60px">
    @foreach(\App\Models\WithdrawProof::where('status', 'approved')->orderByDesc('id')->get() as $proof)
    <?php $user = \App\Models\User::find($proof->user_id); ?>
      <div class="bold_card">
        <div class="card_header">
          <div class="title">
            <img class="avatar" src="/public/uploads/user/avatar.png">
            <div class="info">
              <p class="nickname">{{ $user->name ?? 'User' }}</p>
              <p class="account">
                {{ substr($user->phone ?? '********', 0, 2) }}****{{ substr($user->phone ?? '********', -2) }}
              </p>
            </div>
          </div>
        </div>
        <div class="contents">
          <div class="text">{{ $proof->comment }}</div>
          <div class="image">
            <div class="layui-row layui-col-space10">
              <div class="layui-col-md4 layui-col-xs4">
                <img class="blog_img" src="{{ asset($proof->photo) }}">
              </div>
            </div>
          </div>
        </div>
        <div style="height: 15px;"></div>
        <div class="footer">
          <div class="icon">
            <img src="/mbtech/reward_icon.png" alt=""> R{{ number_format($proof->reward_amount) }}
          </div>
          <div class="date">
            <p>{{ $proof->created_at->format('Y-m-d H:i:s') }}</p>
          </div>
        </div>
      </div>
    @endforeach
  </div>

    <div class="layui-flow-more"><a href="javascript:;"><cite>Load more</cite></a></div>
  </div>

  <!-- Floating Buttons -->
  <div id="blog_post" style="position:fixed;right:0px;color:#666666;bottom:200px;background: #FFFFFF;box-shadow: 0px 4px 10px 0px rgba(0,56,99,0.2);border-radius: 8px;width: 60px;padding: 10px 0;text-align: center">
    <a href="javascript:" class="rules">
      <img src="/mbtech/rules.png" style="width: 32px;height: 32px;">
      <p>Reward</p>
    </a>
    <div style="width: 40px;height: 1px;background:  #E4E4E4;margin:auto;margin-top: 5px"></div>
    <a href="/postBlog">
      <img src="/mbtech/publish.png" style="width: 32px;height: 32px;">
      <p>Release</p>
    </a>
  </div>

  <!-- Footer Navigation -->
  <div class="footer_menu">
    <div class="content">
      <a href="/" class="item"><img src="/mbtech/home.png"><p>Home</p></a>
      <a href="/blog" class="item active"><img src="/mbtech/blog_active.png"><p>Blog</p></a>
      <a href="/invitation" class="item"><img src="/mbtech/invest.png"><p>Team</p></a>
      <a href="/tasks" class="item"><img src="/mbtech/tasks.png"><p>Tasks</p></a>
      <a href="/my" class="item"><img src="/mbtech/my.png"><p>My</p></a>
    </div>
  </div>

  <!-- Reward Dialog -->
  <div class="dialog" id="reward-dialog">
    <div class="dialog_contents">
      <p class="explain">Reward Description</p>
      <p class="title">Share withdrawal screenshots to receive cash rewards</p>
      <p class="text">Send a screenshot of the latest successful withdrawal to the comment section, and once approved, you will immediately receive a reward of 10–777</p>
      <div style="padding: 10px 20px;">
        <p id="close-dialog" class="layui-btn layui-btn-fluid layui-btn-lg" style="background: linear-gradient(270deg, #0672B5 0%, #1C8ED5 100%); border-radius: 100px;">I Know</p>
      </div>
    </div>
  </div>

  <!-- Script to toggle dialog -->
  <script>
    document.addEventListener('DOMContentLoaded', function () {
      const rulesBtn = document.querySelector('.rules');
      const dialog = document.getElementById('reward-dialog');
      const closeBtn = document.getElementById('close-dialog');

      rulesBtn.addEventListener('click', function () {
        dialog.style.display = 'flex';
      });

      closeBtn.addEventListener('click', function () {
        dialog.style.display = 'none';
      });

      dialog.addEventListener('click', function (e) {
        if (e.target === dialog) {
          dialog.style.display = 'none';
        }
      });
    });
  </script>
</body>
</html>
